﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Winfoot_7_SDK;
using WinfootDefaultNetworkPlugin.Controls.Strategy;

namespace WinfootDefaultNetworkPlugin.Controls
{
    public partial class QueryIpMatching : UserControl,IControl,ICorrespondenceOS
    {
        private QueryIpMatchingController queryIpMatchingController;

        public QueryIpMatching()
        {
            InitializeComponent();
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
                                           
#if DEBUG
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsVista_SP2,
                                           OS.WindowsSeven
#endif
                                       };
            
        }

        private void groupBox1_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                UserHelp userHelp = new UserHelp(new Uri(@"SYSTEM\CurrentControlSet\Services\Tcpip\Parameters"));
                userHelp.Show();
            }
        }

        public void SetQueryIpMatchingValue(int i)
        {
            switch (i)
            {
                case 0:
                    checkBox1.Checked = false;
                    break;
                case 1:
                    checkBox1.Checked = true;
                    break;
                default:
                    break;
            }
        }


        public int GetQueryIpMatchingValue()
        {
            if (checkBox1.Checked)
            {
                return 1;
            }
            return 0;
        }

        #region IControl メンバ

        public void Apply()
        {
            queryIpMatchingController.Write();
        }

        public List<WFRegistry> BackUp()
        {
            return queryIpMatchingController.BackUp();
        }

        #endregion

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        private void QueryIpMatching_Load(object sender, EventArgs e)
        {
            WFUtillity wfUtillity = new WFUtillity();
            queryIpMatchingController = new QueryIpMatchingController(this,
                                                                                      (IQueryIpMatchingStrategy)
                                                                                      wfUtillity.
                                                                                          GetCorrespondenceInstance
                                                                                          (new List<ICorrespondenceOS>
                                                                                               {
                                                                                                   new QueryIpMatchingDefaultStrategy()
                                                                                               }));
            queryIpMatchingController.Read();
        }
    }
}
